"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createNotification = createNotification;
exports.createAdminNotification = createAdminNotification;
// backend/src/api/utils/notification.ts
const db_1 = require("@b/db");
const Websocket_1 = require("@b/handler/Websocket");
const task_1 = require("./task");
const console_1 = require("./console");
async function createNotification(options, ctx) {
    var _a, _b, _c;
    try {
        (_a = ctx === null || ctx === void 0 ? void 0 : ctx.step) === null || _a === void 0 ? void 0 : _a.call(ctx, "Creating notification");
        // Wrap the notification creation and sending in a task
        const task = async () => {
            const newRecord = await db_1.models.notification.create({
                userId: options.userId,
                relatedId: options.relatedId,
                title: options.title,
                type: options.type,
                message: options.message,
                details: options.details,
                link: options.link,
                actions: options.actions,
                read: false,
            });
            const plainRecord = newRecord.get({ plain: true });
            Websocket_1.messageBroker.sendToClientOnRoute("/api/user", options.userId, {
                type: "notification",
                method: "create",
                payload: plainRecord,
            });
            return newRecord;
        };
        // Add the task to the queue and await its completion
        const result = await task_1.taskQueue.add(task);
        (_b = ctx === null || ctx === void 0 ? void 0 : ctx.success) === null || _b === void 0 ? void 0 : _b.call(ctx, "Notification created successfully");
        return result;
    }
    catch (err) {
        console_1.logger.error("NOTIF", "Failed to create notification", err);
        (_c = ctx === null || ctx === void 0 ? void 0 : ctx.fail) === null || _c === void 0 ? void 0 : _c.call(ctx, err.message);
        throw err;
    }
}
async function createAdminNotification(permissionName, title, message, type, link, details, actions, ctx) {
    var _a, _b, _c, _d;
    try {
        (_a = ctx === null || ctx === void 0 ? void 0 : ctx.step) === null || _a === void 0 ? void 0 : _a.call(ctx, `Finding users with ${permissionName} permission`);
        // Find all users whose role includes the specified permission
        const users = await db_1.models.user.findAll({
            include: [
                {
                    model: db_1.models.role,
                    as: "role",
                    include: [
                        {
                            model: db_1.models.permission,
                            as: "permissions",
                            through: { attributes: [] },
                            where: { name: permissionName },
                        },
                    ],
                    required: true,
                },
            ],
            attributes: ["id"],
        });
        (_b = ctx === null || ctx === void 0 ? void 0 : ctx.step) === null || _b === void 0 ? void 0 : _b.call(ctx, `Creating notifications for ${users.length} admin users`);
        // Create a task for each user to send the notification
        const tasks = users.map((user) => {
            return async () => {
                await createNotification({
                    userId: user.id,
                    title,
                    message,
                    type,
                    link,
                    details,
                    actions,
                });
            };
        });
        // Add all tasks to the task queue and wait for them to complete
        await Promise.all(tasks.map((task) => task_1.taskQueue.add(task)));
        (_c = ctx === null || ctx === void 0 ? void 0 : ctx.success) === null || _c === void 0 ? void 0 : _c.call(ctx, `Admin notifications created for ${users.length} users`);
    }
    catch (error) {
        console_1.logger.error("NOTIF", "Failed to create admin notification", error);
        (_d = ctx === null || ctx === void 0 ? void 0 : ctx.fail) === null || _d === void 0 ? void 0 : _d.call(ctx, error.message);
        throw error;
    }
}
